/*
 * Decompiled with CFR 0.152.
 */
package apicore.ptmp;

import apicore.message.IPCEventLTV;
import apicore.ptmp.EventListener;
import apicore.ptmp.EventManager;
import apicore.ptmp.PacketTracerSession;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SimpleEventManager
implements EventManager {
    protected PacketTracerSession session;
    protected Map<String, Set<EventListener>> listeners;

    public SimpleEventManager(PacketTracerSession packetTracerSession) {
        this.session = packetTracerSession;
        this.listeners = new HashMap<String, Set<EventListener>>();
    }

    public void start() {
    }

    public void shouldStop() {
    }

    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getClassName();
        Set<EventListener> set = this.listeners.get(string);
        if (set != null) {
            for (EventListener eventListener : set) {
                eventListener.handleEvent(iPCEventLTV);
            }
        }
    }

    public void addListener(String string, EventListener eventListener) {
        Set<EventListener> set = this.listeners.get(string);
        if (set == null) {
            set = new HashSet<EventListener>();
            this.listeners.put(string, set);
            throw new Error("Unimplemented -- addListener needs event registration");
        }
        set.add(eventListener);
    }

    public void removeListener(String string, EventListener eventListener) {
        Set<EventListener> set = this.listeners.get(string);
        if (set != null) {
            set.remove(eventListener);
        }
    }
}

